<?php
/*******************************************************************************
* FPDF Thai Positioning Improve                                                *
*                                                                              *
* Version:  1.01                                                               *
* Date:     2009-10-08                                                         *
* Advisor:  Mr. Wittawas Puntumchinda                                          *
* Coding:   Mr. Sirichai Fuangfoo                                              *
* License:  FPDF                                                               *
*******************************************************************************/

require('fpdf.php');

class FPDF_Thai extends FPDF
{
var $txt_error;	
var $s_error;
var $string_th;
var $s_th;
var $pointX;
var $pointY;
var $curPointX;
var $checkFill;
var $array_th;

/****************************************************************************************
* : Function ͧ Class FPDF_TH													
* ҧԧ: Function MultiCell ͧ Class FPDF											
* ÷ӧҹ: 㹡þͤº÷Ѵͧ͡ PDF 										
* ٺẺ: MultiCell (	$w = ҧͧCell,												
*						$h = ٧ͧCell,												
*						$txt = ͤо,													
*						$border = ˹ʴ鹡ͺ(0 = ʴ, 1= ʴ)	,				
*						$align = ˹觢ͤ(L = , R = , C = 觡ҧ, J = Ш),
*						$fill = ˹ʴբͧCell(false = ʴ, true = ʴ)					
*					)			
*****************************************************************************************/
function MultiCell($w, $h, $txt, $border=0, $align='J', $fill=false)
{
	//Output text with automatic or explicit line breaks
	$cw=&$this->CurrentFont['cw'];
	if($w==0)
		$w=$this->w-$this->rMargin-$this->x;
	$wmax=($w-2*$this->cMargin)*1000/$this->FontSize;
	$s=str_replace("\r",'',$txt);
	$nb=strlen($s);
	if($nb>0 && $s[$nb-1]=="\n")
		$nb--;
	$b=0;
	if($border)
	{
		if($border==1)
		{
			$border='LTRB';
			$b='LRT';
			$b2='LR';
		}
		else
		{
			$b2='';
			if(strpos($border,'L')!==false)
				$b2.='L';
			if(strpos($border,'R')!==false)
				$b2.='R';
			$b=(strpos($border,'T')!==false) ? $b2.'T' : $b2;
		}
	}
	$sep=-1;
	$i=0;
	$j=0;
	$l=0;
	$ns=0;
	$nl=1;
	while($i<$nb)
	{
		//Get next character
		$c=$s{$i};
		if($c=="\n")
		{
			//Explicit line break
			if($this->ws>0)
			{
				$this->ws=0;
				$this->_out('0 Tw');
			}
			$this->MCell($w,$h,substr($s,$j,$i-$j),$b,2,$align,$fill);
			$i++;
			$sep=-1;
			$j=$i;
			$l=0;
			$ns=0;
			$nl++;
			if($border && $nl==2)
				$b=$b2;
			continue;
		}
		if($c==' ')
		{
			$sep=$i;
			$ls=$l;
			$ns++;
		}
		$l+=$cw[$c];
		if($l>$wmax)
		{
			//Automatic line break
			if($sep==-1)
			{
				if($i==$j)
					$i++;
				if($this->ws>0)
				{
					$this->ws=0;
					$this->_out('0 Tw');
				}
				$this->MCell($w,$h,substr($s,$j,$i-$j),$b,2,$align,$fill);
			}
			else
			{
				if($align=='J')
				{
					$this->ws=($ns>1) ? ($wmax-$ls)/1000*$this->FontSize/($ns-1) : 0;
					$this->_out(sprintf('%.3F Tw',$this->ws*$this->k));
				}
				$this->MCell($w,$h,substr($s,$j,$sep-$j),$b,2,$align,$fill);
				$i=$sep+1;
			}
			$sep=-1;
			$j=$i;
			$l=0;
			$ns=0;
			$nl++;
			if($border && $nl==2)
				$b=$b2;
		}
		else
			$i++;
	}
	//Last chunk
	if($this->ws>0)
	{
		$this->ws=0;
		$this->_out('0 Tw');
	}
	if($border && strpos($border,'B')!==false)
		$b.='B';
	$this->MCell($w,$h,substr($s,$j,$i-$j),$b,2,$align,$fill);
	$this->x=$this->lMargin;
}

/****************************************************************************************
*   : Function	ͧ Class FPDF_TH													
* ҧԧ	   : Function Cell	ͧ Class FPDF												
* ÷ӧҹ  : 㹡þͤк÷Ѵͧ͡ PDF 											
* ٺẺ  : Cell (	$w = ҧͧCell,													
*					$h = ٧ͧCell,													
*					$txt = ͤо,													
*					$border = ˹ʴ鹡ͺ(0 = ʴ, 1= ʴ),					
*					$ln = ˹觷Ѵ仨ҡ(0 = , 1 = ÷ѴѴ, 2 = ҹҧ),
*					$align = ˹觢ͤ(L = , R = , C = 觡ҧ, T = , B = ҧ),	
*					$fill = ˹ʴբͧCell(false = ʴ, true = ʴ),					
*					$link = URL ͧͤ§件֧									
*				)	
*****************************************************************************************/
function Cell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
{
	$this->checkFill="";
	$k=$this->k;
	if($this->y+$h>$this->PageBreakTrigger && !$this->InHeader && !$this->InFooter && $this->AcceptPageBreak())
	{
		//˹ѵѵ
		$x=$this->x;
		$ws=$this->ws;
		if($ws>0)
		{
			$this->ws=0;
			$this->_out('0 Tw');
		}
		$this->AddPage($this->CurOrientation);
		$this->x=$x;
		if($ws>0)
		{
			$this->ws=$ws;
			$this->_out(sprintf('%.3F Tw',$ws*$k));
		}
	}
	//˹ҧҡѺ˹ҡд
	if($w==0)
		$w=$this->w-$this->rMargin-$this->x;
	$this->s_th='';
	//˹ʴ鹡ͺ 4 ҹ աͺ
	if($fill || $border==1)
	{
		if($fill)
			$op=($border==1) ? 'B' : 'f';
		else
			$op='S';
		$this->s_th=sprintf('%.2F %.2F %.2F %.2F re %s ',$this->x*$k,($this->h-$this->y)*$k,$w*$k,-$h*$k,$op);
		if($op=='f')
			$this->checkFill=$op;
	}
	//˹ʴ鹡ͺ
	if(is_string($border))
	{
		$x=$this->x;
		$y=$this->y;
		if(strpos($border,'L')!==false)
			$this->s_th.=sprintf('%.2F %.2F m %.2F %.2F l S ',$x*$k,($this->h-$y)*$k,$x*$k,($this->h-($y+$h))*$k);
		if(strpos($border,'T')!==false)
			$this->s_th.=sprintf('%.2F %.2F m %.2F %.2F l S ',$x*$k,($this->h-$y)*$k,($x+$w)*$k,($this->h-$y)*$k);
		if(strpos($border,'R')!==false)
			$this->s_th.=sprintf('%.2F %.2F m %.2F %.2F l S ',($x+$w)*$k,($this->h-$y)*$k,($x+$w)*$k,($this->h-($y+$h))*$k);
		if(strpos($border,'B')!==false)
			$this->s_th.=sprintf('%.2F %.2F m %.2F %.2F l S ',$x*$k,($this->h-($y+$h))*$k,($x+$w)*$k,($this->h-($y+$h))*$k);
	}


	if($txt!=='')
	{			
		$x=$this->x;
		$y=$this->y;
		//˹èѴͤдѺ
		if(strpos($align,'R')!==false)
			$dx=$w-$this->cMargin-$this->GetStringWidth($txt);
		elseif(strpos($align,'C')!==false)
			$dx=($w-$this->GetStringWidth($txt))/2;
		else
			$dx=$this->cMargin;
		//˹èѴͤǴ
		if(strpos($align,'T')!==false)
			$dy=$h-(.7*$this->k*$this->FontSize);
		elseif(strpos($align,'B')!==false)
			$dy=$h-(.3*$this->k*$this->FontSize);
		else
			$dy=.5*$h;
		//˹âմͤ
		if($this->underline)
		{	
			//˹ѹ֡ҿԡ
			if($this->ColorFlag)
				$this->s_th.=' q '.$this->TextColor.' ';
			//մͤ0
			$this->s_th.=' '.$this->_dounderline($this->x+$dx,$this->y+.5*$h+.3*$this->FontSize,$txt);
			//˹׹ҡҿԡ
			if($this->ColorFlag)
				$this->s_th.=' Q ';
		}
		//˹ͤ§件֧
		if($link)
			$this->Link($this->x,$this->y,$this->GetStringWidth($txt),$this->FontSize,$link);
		/*if($s)
			$this->_out($s);
		$s='';*/
		//Ѵѡ͡ҡͤ еŧ
		$this->array_th=substr($txt,0);
		$i=0;
		$this->pointY=($this->h-($y+$dy+.3*$this->FontSize))*$k;
		$this->curPointX=($x+$dx)*$k;
		$this->string_th='';
		$this->txt_error=0;

		while($i<strlen($txt))
		{	
			//˹˹觷оѡ
			if(strpos('',$this->array_th[$i])!==false)
			{
				$pX=$x+$dx;
				if($i>0)
					$pX+=.02*$this->GetStringWidth($this->array_th[$i-1]);
				$this->pointX=$pX*$k;
				//Ǩͺѡ Ѻ˹зӡþ
				$this->_checkT($i);

				if($this->txt_error==0)
					$this->string_th.=$this->array_th[$i];
				else
				{
					$this->txt_error=0;
				}
			}
			else
				$this->string_th.=$this->array_th[$i];

			//͹˹ x 价ǷоѴ
			$x=$x+$this->GetStringWidth($this->array_th[$i]);
			$i++;
		}
		$this->TText($this->curPointX,$this->pointY,$this->string_th);
		/*$this->s_th.=$this->s_hidden.$this->s_error;*/
		//$this->s_th.=$this->s_error;
		if($this->s_th)
			$this->_out($this->s_th);
	}
	else
		//Ӥʴբͤ
		$this->_out($this->s_th);

	$this->lasth=$h;
	//Ǩͺҧ˹觢ͧѴ
	if($ln>0)
	{
		//鹺÷Ѵ
		$this->y+=$h;
		if($ln==1)
			$this->x=$this->lMargin;
	}
	else
		$this->x+=$w;
}

/********************************************************************************
* ҹ: Function	Cell ͧ Class FPDF_TH										
* ÷ӧҹ: 㹡õǨͺѡ лѺ˹觡͹зӡþ							
* ͧ: $this->array_th = ͧѡ÷Ѵ͡ҡͤ						
*						$i = ӴѺѨغѹзӡõǨͺ						
*						$s = ѡТͧ⤴ PDF
*********************************************************************************/
function _checkT($i)
{   
	$pointY=$this->pointY;
	$pointX=$this->pointX;
	$nb=strlen($this->array_th);
	//ǨͺʴŢͧѡ˹к
	if($this->_errorTh($this->array_th[$i])==1)
	{
		//Ǩͺѡá͹˹ҹк Ѻ˹ŧ	
		if(($this->_errorTh($this->array_th[$i-1])!=2)&&($this->array_th[$i+1]!=""))
		{
			//ҵǹ͡ѵ
			if($this->array_th[$i]==""||$this->array_th[$i]=="")
			{
				$pointY=$this->pointY-.2*$this->FontSize*$this->k;
				$this->txt_error=1;
			}
			//ҵǹ
			elseif($this->array_th[$i]==''||$this->array_th[$i]=='')
			{
				$pointY=$this->pointY-.23*$this->FontSize*$this->k;
				$this->txt_error=1;
			}
			//ҵǹ繡ѹ
			else
			{
				$pointY=$this->pointY-.17*$this->FontSize*$this->k;
				$this->txt_error=1;
			}
		}
			
		//Ǩͺѡõǡ͹˹ҹ繵ѡҧǺ
		if($this->_errorTh($this->array_th[$i-1])==3)		
		{
			//ҵǹ͡ѵ
			if($this->array_th[$i]==""||$this->array_th[$i]=="")
			{
				$pointX=$this->pointX-.17*$this->GetStringWidth($this->array_th[$i-1])*$this->k;
				$this->txt_error=1;
			}
			//ҵǹ
			elseif($this->array_th[$i]==''||$this->array_th[$i]=='')
			{			
				$pointX=$this->pointX-.25*$this->GetStringWidth($this->array_th[$i-1])*$this->k;
				$this->txt_error=1;
			}
			//ҵǹ繡ѹ
			else
			{
				$pointX=$this->pointX-.4*$this->GetStringWidth($this->array_th[$i-1])*$this->k;
				$this->txt_error=1;
			}
		}

		//Ǩͺѡõǡ͹˹ҹա繵ѡҧǺ	
		if($i>=2 && $this->_errorTh($this->array_th[$i-2])==3)	
		{					
			//ҵǹ͡ѵ
			if($this->array_th[$i]==""||$this->array_th[$i]=="")
			{
				$pointX=$this->pointX-.17*$this->GetStringWidth($this->array_th[$i-2])*$this->k;
				$this->txt_error=1;
			}
			//ҵǹ
			elseif($this->array_th[$i]==''||$this->array_th[$i]=='')
			{						
				$pointX=$this->pointX-.25*$this->GetStringWidth($this->array_th[$i-2])*$this->k;
				$this->txt_error=1;
			}
			//ҵǹ繡ѹ
			else
			{
				$pointX=$this->pointX-.4*$this->GetStringWidth($this->array_th[$i-2])*$this->k;						
				$this->txt_error=1;
			}
		}
	}
	//õǨͺѡ˹к

	//ǨͺʴŢͧѡк
	elseif($this->_errorTh($this->array_th[$i])==2)
	{
		//Ǩͺѡõǡ͹˹ҹ繵ѡҧǺ
		if($this->_errorTh($this->array_th[$i-1])==3)	
		{
			$pointX=$this->pointX-.17*$this->GetStringWidth($this->array_th[$i-1])*$this->k;
			$this->txt_error=1;
		}
		//ҵǹ
		if($this->array_th[$i]=="")
			//Ǩͺѡõǡ͹˹ҹ繵ѡҧǺ
			if($this->_errorTh($this->array_th[$i-2])==3)	
			{
				$pointX=$this->pointX-.17*$this->GetStringWidth($this->array_th[$i-2])*$this->k;
				$this->txt_error=1;
			}
	}																						
	//õǨͺѡк

	//ǨͺʴŢͧѡҧ
	elseif($this->_errorTh($this->array_th[$i])==6)
	{
		//Ǩͺѡõǡ͹˹ҹ繵ѡ . Ѻ .
		if($this->_errorTh($this->array_th[$i-1])==5)						
		{	//$this->string_th		$this->curPointX
			$this->TText($this->curPointX,$this->pointY,$this->string_th);
			$this->string_th='';
			$this->curPointX=$this->pointX;

			if($this->checkFill=='f')
				$this->s_th.=' q ';
			else
				$this->s_th.=' q 1 g ';
			//ҧ任Դҹҧͧѡ . Ѻ . $s.
			$this->s_th.=sprintf('%.2F %.2F %.2F %.2F re f ',$this->pointX-$this->GetStringWidth($this->array_th[$i-1])*$this->k,$this->pointY-.27*$this->FontSize*$this->k,.9*$this->GetStringWidth($this->array_th[$i-1])*$this->k,.25*$this->FontSize*$this->k);
			$this->s_th.=' Q ';

			$this->txt_error=1;
		}
		//Ǩͺѡõǡ͹˹ҹѡ . Ѻ .
		elseif($this->_errorTh($this->array_th[$i-1])==4)							
		{
			$pointY=$this->pointY-.25*$this->FontSize*$this->k;
			$this->txt_error=1;
		}
		//õǨͺѡҧ
	}																						
	//õǨͺѡҧ
		
	if($this->txt_error==1)
		$this->TText($pointX,$pointY,$this->array_th[$i]);
}

/********************************************************************************
* ҹ: Function	_checkT ͧ Class FPDF_TH				
* ÷ӧҹ: 㹡õǨͺѡ÷ҨзԴþԴҴ			
* ͧ: $char_th = ѡ÷㹡ºº			
*********************************************************************************/
function _errorTh($char_th)
{	
	$txt_error=0;
	//ѡú-
	if(($char_th=='')||($char_th=='')||($char_th=='')||($char_th=='')||($char_th==''))
		$txt_error=1;
	//ѡú
	elseif(($char_th=='')||($char_th=='')||($char_th=='')||($char_th=='')||($char_th=='')||($char_th=='')||($char_th==''))
		$txt_error=2;
	//ѡáҧ-
	elseif(($char_th=='')||($char_th=='')||($char_th==''))
		$txt_error=3;
	//ѡáҧ-ҧ
	elseif(($char_th=='')||($char_th==''))
		$txt_error=4;
	//ѡáҧ-ҧ
	elseif(($char_th=='')||($char_th==''))
		$txt_error=5;
	//ѡҧ
	elseif(($char_th=='')||($char_th==''))
		$txt_error=6;
	else
		$txt_error=0;
	return $txt_error;
}

/********************************************************************************
* ҹ: Function	_checkT ͧ Class FPDF_TH									*
* ÷ӧҹ: 㹾ѡ÷Ǩͺ									*
* ͧ: $txt_th = ѡ 1  Ǩͺ							*
*						$s = ѡТͧ⤴ PDF								*
*********************************************************************************/
function TText($pX, $pY, $txt_th)
{	
	//Ǩͺ
	if($this->ColorFlag)
		$this->s_th.=' q '.$this->TextColor.' ';
	$txt_th2=str_replace(')','\\)',str_replace('(','\\(',str_replace('\\','\\\\',$txt_th)));
	//кص˹ оѡ
	$this->s_th.=sprintf(' BT %.2F %.2F Td (%s) Tj ET ',$pX,$pY,$txt_th2);
	if($this->ColorFlag)
		$this->s_th.=' Q ';
}

/****************************************************************************************
* ҹ: called by function MultiCell within this class								
* ҧԧ: Function Cell	ͧ Class FPDF												
* ÷ӧҹ: 㹡þͤк÷Ѵͧ͡ PDF 											
* ٺẺ: MCell (	$w = ҧͧCell,													
*					$h = ٧ͧCell,													
*					$txt = ͤо,													
*					$border = ˹ʴ鹡ͺ(0 = ʴ, 1= ʴ),					
*					$ln = ˹觷Ѵ仨ҡ(0 = , 1 = ÷ѴѴ, 2 = ҹҧ),
*					$align = ˹觢ͤ(L = , R = , C = 觡ҧ, T = , B = ҧ),	
*					$fill = ˹ʴբͧCell(false = ʴ, true = ʴ)			
*					$link = URL ͧͤ§件֧		
*				)
*****************************************************************************************/
function MCell($w, $h=0, $txt='', $border=0, $ln=0, $align='', $fill=false, $link='')
{
	$this->checkFill="";
	$k=$this->k;
	if($this->y+$h>$this->PageBreakTrigger && !$this->InHeader && !$this->InFooter && $this->AcceptPageBreak())
	{
		//˹ѵѵ
		$x=$this->x;
		$ws=$this->ws;
		if($ws>0)
		{
			$this->ws=0;
			$this->_out('0 Tw');
		}
		$this->AddPage($this->CurOrientation);
		$this->x=$x;
		if($ws>0)
		{
			$this->ws=$ws;
			$this->_out(sprintf('%.3F Tw',$ws*$k));
		}
	}
	//˹ҧҡѺ˹ҡд
	if($w==0)
		$w=$this->w-$this->rMargin-$this->x;
	$this->s_th='';
	//˹ʴ鹡ͺ 4 ҹ աͺ
	if($fill || $border==1)
	{
		if($fill)
			$op=($border==1) ? 'B' : 'f';
		else
			$op='S';
		$this->s_th=sprintf('%.2F %.2F %.2F %.2F re %s ',$this->x*$k,($this->h-$this->y)*$k,$w*$k,-$h*$k,$op);
		if($op=='f')
			$this->checkFill=$op;
	}
	//˹ʴ鹡ͺ
	if(is_string($border))
	{
		$x=$this->x;
		$y=$this->y;
		if(strpos($border,'L')!==false)
			$this->s_th.=sprintf('%.2F %.2F m %.2F %.2F l S ',$x*$k,($this->h-$y)*$k,$x*$k,($this->h-($y+$h))*$k);
		if(strpos($border,'T')!==false)
			$this->s_th.=sprintf('%.2F %.2F m %.2F %.2F l S ',$x*$k,($this->h-$y)*$k,($x+$w)*$k,($this->h-$y)*$k);
		if(strpos($border,'R')!==false)
			$this->s_th.=sprintf('%.2F %.2F m %.2F %.2F l S ',($x+$w)*$k,($this->h-$y)*$k,($x+$w)*$k,($this->h-($y+$h))*$k);
		if(strpos($border,'B')!==false)
			$this->s_th.=sprintf('%.2F %.2F m %.2F %.2F l S ',$x*$k,($this->h-($y+$h))*$k,($x+$w)*$k,($this->h-($y+$h))*$k);
	}


	if($txt!=='')
	{			
		$x=$this->x;
		$y=$this->y;
		//˹èѴͤдѺ
		if(strpos($align,'R')!==false)
			$dx=$w-$this->cMargin-$this->GetStringWidth($txt);
		elseif(strpos($align,'C')!==false)
			$dx=($w-$this->GetStringWidth($txt))/2;
		else
			$dx=$this->cMargin;
		//˹èѴͤǴ
		if(strpos($align,'T')!==false)
			$dy=$h-(.7*$this->k*$this->FontSize);
		elseif(strpos($align,'B')!==false)
			$dy=$h-(.3*$this->k*$this->FontSize);
		else
			$dy=.5*$h;
		//˹âմͤ
		if($this->underline)
		{	
			//˹ѹ֡ҿԡ
			if($this->ColorFlag)
				$this->s_th.='q '.$this->TextColor.' ';
			//մͤ0
			$this->s_th.=' '.$this->_dounderline($this->x+$dx,$this->y+.5*$h+.3*$this->FontSize,$txt);
			//˹׹ҡҿԡ
			if($this->ColorFlag)
				$this->s_th.=' Q';
		}
		//˹ͤ§件֧
		if($link)
			$this->Link($this->x,$this->y,$this->GetStringWidth($txt),$this->FontSize,$link);
		if($this->s_th)
			$this->_out($this->s_th);
		$this->s_th='';
		//Ѵѡ͡ҡͤ еŧ
		$this->array_th=substr($txt,0);
		$i=0;

		while($i<strlen($txt))
		{	
			//˹˹觷оѡ
			$this->pointX=($x+$dx+.02*$this->GetStringWidth($this->array_th[$i-1]))*$k;
			$this->pointY=($this->h-($y+$dy+.3*$this->FontSize))*$k;
			//Ǩͺѡ Ѻ˹зӡþ
			$this->_checkT($i);
			if($this->txt_error==0)
				$this->TText($this->pointX,$this->pointY,$this->array_th[$i]);
			else
			{
				$this->txt_error=0;
			}
			//ǨͺŢ˹
			if($this->array_th[$i]=='{'&&$this->array_th[$i+1]=='n'&&$this->array_th[$i+2]=='b'&&$this->array_th[$i+3]=='}')
				$i=$i+3;
			//͹˹ x 价ǷоѴ
			$x=$x+$this->GetStringWidth($this->array_th[$i]);
			$i++;
		}
		$this->_out($this->s_th);
	}
	else
		//Ӥʴբͤ
		$this->_out($this->s_th);

	$this->lasth=$h;
	//Ǩͺҧ˹觢ͧѴ
	if($ln>0)
	{
		//鹺÷Ѵ
		$this->y+=$h;
		if($ln==1)
			$this->x=$this->lMargin;
	}
	else
		$this->x+=$w;
}
//End of class
}

?>
