<?php
require('fpdf.php');

class PDF_Grid extends FPDF {
	var $grid = false;

	function DrawGrid()
	{
		if($this->grid===true){
			$spacing = 5;
		} else {
			$spacing = $this->grid;
		}
		$this->SetDrawColor(204,255,255);
		$this->SetLineWidth(0.35);
		for($i=0;$i<$this->w;$i+=$spacing){
			$this->Line($i,0,$i,$this->h);
		}
		for($i=0;$i<$this->h;$i+=$spacing){
			$this->Line(0,$i,$this->w,$i);
		}
		$this->SetDrawColor(0,0,0);

		$x = $this->GetX();
		$y = $this->GetY();
		$this->SetFont('Arial','I',8);
		$this->SetTextColor(204,204,204);
		for($i=20;$i<$this->h;$i+=20){
			$this->SetXY(1,$i-3);
			$this->Write(4,$i);
		}
		for($i=20;$i<(($this->w)-($this->rMargin)-10);$i+=20){
			$this->SetXY($i-1,1);
			$this->Write(4,$i);
		}
		$this->SetXY($x,$y);
	}

	function Header()
	{
		if($this->grid)
			$this->DrawGrid();
	}
}
?>
